/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser.ast;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.util.ExprBytesUtils;

public final class ArrayAccessExpression
implements Expression {
    private Expression array;
    private Expression index;

    public ArrayAccessExpression(ByteBuf buf) {
        this(ExprBytesUtils.readExpression(buf), ExprBytesUtils.readExpression(buf));
    }

    public ArrayAccessExpression(@NotNull Expression array, @NotNull Expression index) {
        this.array = Objects.requireNonNull(array, "array");
        this.index = Objects.requireNonNull(index, "index");
    }

    @NotNull
    public Expression array() {
        return this.array;
    }

    public void array(@NotNull Expression array) {
        this.array = Objects.requireNonNull(array, "array");
    }

    @NotNull
    public Expression index() {
        return this.index;
    }

    public void index(@NotNull Expression index) {
        this.index = Objects.requireNonNull(index, "index");
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitArrayAccess(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ExprBytesUtils.writeExpression(this.array(), buf);
        ExprBytesUtils.writeExpression(this.index(), buf);
    }

    @NotNull
    public String toString() {
        return String.format("%s[%s]", this.array, this.index);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayAccessExpression that = (ArrayAccessExpression)o;
        if (!this.array.equals(that.array)) {
            return false;
        }
        return this.index.equals(that.index);
    }

    public int hashCode() {
        int result = this.array.hashCode();
        result = 31 * result + this.index.hashCode();
        return result;
    }
}

